<?php
    
    header('Access-Control-Allow-Origin: *');
    header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
    header("Access-Control-Allow-Credentials: true");
    header("Access-Control-Max-Age: 86400");
    header("Access-Control-Allow-Headers: X-Requested-With");
    
    // Include database connection
    include "./connify.php";
    
    $category = 'Clearance'; // Define the category to filter
    
    // Prepare the SQL query
    $stmt = $con->prepare("SELECT product, product_id, category_id, weight, img, price, discount, qty, product_type 
                            FROM product 
                            WHERE category = ? 
                            ORDER BY id 
                            LIMIT 10");
    
    // Bind the parameter
    $stmt->bind_param("s", $category);
    
    // Execute the statement
    $stmt->execute();
    
    // Bind the results
    $stmt->bind_result($product, $product_id, $category_id, $weight, $img, $price, $discount, $qty, $product_type);
    
    // Fetch data into an array
    $categories = [];
    while ($stmt->fetch()) {
        $categories[] = [
            "product" => $product,
            "product_id" => $product_id,
            "category_id" => $category_id,
            "weight" => $weight,
            "img" => $img,
            "price" => '£' . (!empty($price) ? $price : 0), // Set default price to 0 if empty
            "discount" => $discount,
            "qty" => $qty,
            "product_type" => $product_type
        ];
    }
    
    // Return data as JSON
    header('Content-Type: application/json');
    echo json_encode($categories);
    
    // Close connections
    $stmt->close();
    $con->close();

?>
