<?php

    ini_set('display_errors', 1);
    ini_set('display_startup_errors', 1);
    error_reporting(E_ALL);

    header('Access-Control-Allow-Origin: *');
    header('Access-Control-Allow-Methods: GET, POST', 'OPTIONS');
    header("Access-Control-Allow-Credentials: true");
    header("Access-Control-Max-Age: 86400");
    header("Access-Control-Allow-Headers: X-Requested-With");
    // header("Access-Control-Allow-Headers", "Access-Control-Allow-Headers, Origin,Accept, X-Requested-With, Content-Type, Access-Control-Request-Method, Access-Control-Request-Headers");


    include "./connify.php";
    // include "./clean.php";
     
    $userHash          = (mysqli_real_escape_string($con,$_POST['userHash']));
    
    
    
    $stmt = $con->prepare('SELECT id, email FROM users WHERE token = ?');
    $stmt->bind_param('s', $userHash);
    $stmt->execute();
    $stmt->store_result();
    $stmt->bind_result($userId, $email);
    $userExists = $stmt->num_rows;
    $stmt->fetch();
    
    if ($userExists === 0) {
       
        $msg = "Session expired, kidnly login again";
        echo json_encode(['message' => $msg]);
        exit();
        
    }
    $stmt->close();
    
    
    $stmt = $con -> prepare('SELECT product_id,qty,price FROM pay_now WHERE  token =?'); 
    $stmt -> bind_param('s',$userHash); 
    $stmt -> execute(); 
    $stmt -> store_result(); 
    $stmt -> bind_result($product_id,$quant,$prix);
    $count  = $stmt->num_rows;
    $stmt -> fetch();
    
    if($count >= 1){
        
        $stmt = $con -> prepare('SELECT product,product_type,weightType,qty,moq,tax,img FROM product WHERE  product_id =?'); 
        $stmt -> bind_param('s',$product_id); 
        $stmt -> execute(); 
        $stmt -> store_result(); 
        $stmt -> bind_result($product,$product_type,$weightType,$qty,$moq,$tax,$img);
        $count  = $stmt->num_rows;
        $stmt -> fetch();
        
        if($quant > $qty){
            
            $msg = "Currently out of stock!!";
            echo json_encode(['message' => $msg]);
            exit();
            
        }else{
            
            $taxed = $prix * ($tax/100);
            $total = $taxed + $prix;
            
            if($weightType === 'wp'){
                
                if($product_type === 'rp'){
                    
                    // retail Product - singlar sale applicable!
                    $stmt = $con -> prepare('SELECT weight,weight_id,img,kg FROM weights WHERE  product_id =? AND price =?'); 
                    $stmt -> bind_param('ss',$product_id,$prix); 
                    $stmt -> execute(); 
                    $stmt -> store_result(); 
                    $stmt -> bind_result($weight,$weight_id,$img,$kg);
                    $count  = $stmt->num_rows;
                    $stmt -> fetch();
                    
                     
                    $result = $con->query("SELECT * FROM weight_price"); 
                    while ($row = $result->fetch_assoc()) {
                        if ($kg >= $row['min'] && $kg <= $row['max']) {
                            // print_r($row);
                            $kgPrice = $row['price'] ;
                            $kg_price = $row['price'] ;
                            $kg_msg = 'good';
                        }else{
                             $kg_price = 0 ;
                             $kg_msg = 'none';
                             $kgPrice = 'Proceed with payment, contact us for shipping cost negotiation' ;
                        }
                    }
                    
                    $total = $taxed + $prix + $kg_price;
                    
                   $msg = 'success';
                    $output = array('message'=>$msg,'qty'=>$quant, 'total'=> $total, 'product'=>$product,'amount'=>$prix,'overall'=>'£'.number_format($total, 2), 'sub_total'=>'£'.number_format($prix, 2),  'tax' => '£'.number_format($taxed, 2), 'kg_msg'=>$kg_msg, 'kgPrice'=>$kgPrice,  'product_id'=> $product_id
                            ,'img'=> $img );
                    echo json_encode($output);
                    exit();
                    
                    
                    
                }else{
                    // whole sale product - moq applicable
                    if($quant < $moq){
                        
                        $msg = "Minimum Order is $quant";
                        echo json_encode(['message' => $msg]);
                        exit();
                        
                    }else{
                        
                        
                        // retail Product - singlar sale applicable!
                        $stmt = $con -> prepare('SELECT weight,weight_id,img,kg FROM weights WHERE  product_id =? AND price =?'); 
                        $stmt -> bind_param('ss',$product_id,$prix); 
                        $stmt -> execute(); 
                        $stmt -> store_result(); 
                        $stmt -> bind_result($weight,$weight_id,$img,$kg);
                        $count  = $stmt->num_rows;
                        $stmt -> fetch();
                        
                        $result = $con->query("SELECT * FROM weight_price"); 
                        while ($row = $result->fetch_assoc()) {
                            if ($kg >= $row['min'] && $kg <= $row['max']) {
                                // print_r($row);
                                $kgPrice = $row['price'] ;
                                $kg_price = $row['price'] ;
                                $kg_msg = 'good';
                            }else{
                                 $kg_price = 0 ;
                                 $kg_msg = 'none';
                                 $kgPrice = 'Proceed with payment, contact us for shipping cost negotiation' ;
                            }
                        }
                        
                        $total = $taxed + $prix + $kg_price;
         
                         
                        
                        $msg = 'success';
                        $output = array('message'=>$msg,'qty'=>$quant, 'total'=> $total,'product'=>$product,'amount'=>$prix,'overall'=>'£'.number_format($total, 2), 'sub_total'=>'£'.number_format($prix, 2),  'tax' => '£'.number_format($taxed, 2), 'kg_msg'=>$kg_msg, 'kgPrice'=>$kgPrice,  'product_id'=> $product_id
                                ,'img'=> $img );
                        echo json_encode($output);
                        exit();
                        
                        
                    }
                    
                    
                }
                
                
            }else{
                
                // non variant product
                $msg = 'success';
                $output = array('message'=>$msg,'qty'=>$quant,'total'=> $total, 'product'=>$product,'amount'=>$prix,'overall'=>'£'.number_format($total, 2), 'sub_total'=>'£'.number_format($prix, 2),  'tax' => '£'.number_format($taxed, 2), 'product_id'=> $product_id
                        ,'img'=> $img );
                echo json_encode($output);
                exit();
                
                
                
                
            }
            
        }
        
    }else{
        
        $msg = "Pay now cart is empty";
        echo json_encode(['message' => $msg]);
        exit();
        
        
    }

   
    
      
    
    


?>