<?php


    header('Access-Control-Allow-Origin: *');
    header('Access-Control-Allow-Methods: GET, POST');
    header("Access-Control-Allow-Credentials: true");
    header("Access-Control-Max-Age: 86400");
    header("Access-Control-Allow-Headers: X-Requested-With, Content-Type");
    
    // Include connection file
    include "./connify.php";
    
    // Ensure POST data is sanitized and cast to float
    $min = (float)mysqli_real_escape_string($con, $_POST['min']);
    $max = (float)mysqli_real_escape_string($con, $_POST['max']); 
    
    // Use prepared statement to prevent SQL injection
    $stmt = $con->prepare("SELECT details,product, product_id, category_id, weight, img, price, discount, qty, product_type 
                           FROM product 
                           WHERE CAST(price AS DECIMAL(10,2)) BETWEEN ? AND ? 
                           ORDER BY id");
    
    // Bind parameters to the prepared statement (bind as doubles 'd' for float values)
    $stmt->bind_param("dd", $min, $max);  // 'd' means double (float) for price range
    
    $stmt->execute();
    $stmt->bind_result($description,$product, $product_id, $category_id, $weight, $img, $price, $discount, $qty, $product_type);
    
    // Fetch data into an array
    $categories = [];
    while ($stmt->fetch()) {
        if (empty($price)) {
            $price = 0;
        }
        $categories[] = [
            "product" => $product,
            "product_id" => $product_id,
            "category_id" => $category_id,
            "weight" => $weight,
            "img" => $img,
            "price" => '£' . number_format($price, 2),  // Format price as currency
            "discount" => $discount,
            "qty" => $qty,
            'product_type' => $product_type,
            'description' => $description
        ];
    }
    
    // Return data as JSON
    header('Content-Type: application/json');
    echo json_encode($categories);
    
    // Close connections
    $stmt->close();
    $con->close();
    

?>
