<?php
    // Set headers for CORS
    header('Access-Control-Allow-Origin: *');
    header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
    header('Access-Control-Allow-Credentials: true');
    header('Access-Control-Max-Age: 86400');
    header('Access-Control-Allow-Headers: Origin, Accept, X-Requested-With, Content-Type, Access-Control-Request-Method, Access-Control-Request-Headers');
    
    // Handle OPTIONS preflight requests
    if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
        http_response_code(200);
        exit();
    }
    
    // Include database connection
    include "./connify.php";
    
    // Check if required POST fields are set
    if (isset($_POST['email'], $_POST['pwd'], $_POST['token'])) {
        $email = mysqli_real_escape_string($con, $_POST['email']);
        $password = $_POST['pwd']; // Plain text password (no need to escape)
        $token = mysqli_real_escape_string($con, $_POST['token']);
    
        // Prepare the SQL statement to fetch user details
        $stmt = $con->prepare('SELECT id, password, token FROM users WHERE email = ?');
        if (!$stmt) {
            echo json_encode(['message' => 'Database error']);
            exit();
        }
    
        $stmt->bind_param('s', $email);
        $stmt->execute();
        $stmt->store_result();
    
        // Check if user exists
        if ($stmt->num_rows === 0) {
            echo json_encode(['message' => 'Wrong credentials']);
            $stmt->close();
            exit();
        }
    
        $stmt->bind_result($userId, $dbPassword, $dbToken);
        $stmt->fetch();
    
        // Verify the password
        if (password_verify($password, $dbPassword)) {
            // Update token in the database
            $updateStmt = $con->prepare('UPDATE users SET token = ? WHERE email = ?');
            if (!$updateStmt) {
                echo json_encode(['message' => 'Database error']);
                exit();
            }
             
            $updateStmt->bind_param('ss', $token, $email);
            if ($updateStmt->execute()) {
                echo json_encode(['message' => 'success', 'email' => $email]);
            } else {
                echo json_encode(['message' => 'Failed to update token']);
            }
    
            $updateStmt->close();
        } else {
            echo json_encode(['message' => 'Wrong Password']);
        }
    
        $stmt->close();
    } else {
        echo json_encode(['message' => 'Invalid request']);
    }
    
    $con->close();
    exit();
?>
