<?php

    header('Access-Control-Allow-Origin: *');
    header('Access-Control-Allow-Methods: GET, POST', 'OPTIONS');
    header("Access-Control-Allow-Credentials: true");
    header("Access-Control-Max-Age: 86400");
    header("Access-Control-Allow-Headers: X-Requested-With");
    // header("Access-Control-Allow-Headers", "Access-Control-Allow-Headers, Origin,Accept, X-Requested-With, Content-Type, Access-Control-Request-Method, Access-Control-Request-Headers");


    include "./connify.php";
    // include "./clean.php";
     

  
    $product         = (mysqli_real_escape_string($con,$_POST['product']));
    $userHash        = (mysqli_real_escape_string($con,$_POST['userHash']));
    $product_id = $product;
    
 

    
    $stmt = $con -> prepare('SELECT  product,category,weight,img,qty,price,fake_price,moq,description,details,product_type,weightType,shipping FROM product WHERE  product_id =?'); 
    $stmt -> bind_param('s',$product); 
    $stmt -> execute(); 
    $stmt -> store_result(); 
    $stmt -> bind_result($product,$category,$weight,$img,$qty,$price,$discount,$moq,$description,$details,$product_type,$weightType,$shipping);
    $count  = $stmt->num_rows;
    $stmt -> fetch();

     
    if($count >= 1){
        
        
        if($weightType === 'wp'){
            
            $stmt = $con -> prepare('SELECT  price FROM weights WHERE  product_id =?'); 
            $stmt -> bind_param('s',$product_id); 
            $stmt -> execute(); 
            $stmt -> store_result(); 
            $stmt -> bind_result($price);
            $count  = $stmt->num_rows;
            $stmt -> fetch();
             
        } 
        
        
        $status = 'active';
        $stmt = $con -> prepare('SELECT  id  FROM reviews  WHERE  product_id = ? AND status = ?'); 
        $stmt -> bind_param('ss',$product_id,$status); 
        $stmt -> execute(); 
        $stmt -> store_result(); 
        $stmt -> bind_result($i);
        $reviews  = $stmt->num_rows;
        $stmt -> fetch();
        
        if($product_type === 'wsp'){
            
            $stmt = $con -> prepare('SELECT  id,userType,status  FROM users  WHERE  token = ?'); 
            $stmt -> bind_param('s',$userHash); 
            $stmt -> execute(); 
            $stmt -> store_result(); 
            $stmt -> bind_result($i,$userType,$status);
            $count  = $stmt->num_rows;
            $stmt -> fetch();
            
            if($userType === 'wholesale'){
                if($status === 'approved'){
                    $whoslesale = true;
                }else{
                    $whoslesale = 'not-false';
                }
            }else{
                $whoslesale = false;
            }
            
        }
        
        
        
        $msg = "success";
        $output = array('message'=>$msg,'whoslesale' => $whoslesale,'moq'=> $moq, 'shipping' => $shipping,'reviews' => $reviews,'description'=>$description,'product' => $product,  'category' => $category, 'weight' => $weight, 'img' => $img, 'qty' => $qty, 'price' => $price, 'discount' => $discount, 'details' => $details,'product_type'=>$product_type,'weightType'=>$weightType);
        echo json_encode($output);
        exit(); 
        
        
    }else{
        
        
       
        
        $msg = "Unable to fetch data";
        $output = array('message'=>$msg);
        echo json_encode($output);
        exit();
        
         
         
        
    } 
   
    
    
    


?>